// Exp-8 Application of Correlation in RADAR Signal Processing to detect Object and it's Distance.

// Objective : Correlation finds application in RADAR Signal Processing, in which the objective is to find whether the object is presence or Absence. it also required to find the distance between object and radar.

// R[n]=Alpha*X[n-D]+Noise    where Alpha= Attenution Factor = 1 and D= Delay factor by which transmitted signal is received back to receiver(RADAR)

// Observation : In the presence of object the received signal is reflected signal fron the object which can be given by R(n) = X(n-D)+Noise. if we find the correlation between received signal and transmitted signal, than the correlation value is higher at the delay index.

// Observation :In the Absence of object the received signal is only the Noise, which can be given by R(n) = Noise. if we find the correlation between received signal and transmitted signal, than the correlation value is not higher at the delay index what we have get in the presence of object.

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7

clc;
clear;
xdel(winsid());

x=[0 1 2 3 2 1 0];          //Triangle pulse transmitted by radar
n=[-3 -2 -1 0 1 2 3];       // Index of Triangular Pulse
D=10;                       // Delay amount
nd=n+D;                     // Index of Delayed Signal
y=x;                        // Delayed Signal

scf();
subplot(2,1,1);
bar(n,x,0.1,'red');
title('Original Transmitted Signal','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

subplot(2,1,2);
bar(nd,y,0.1,'yellow');
title('Delayed Signal','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

w=rand(1,length(x));      // Noise Generation
nw=nd;
scf();
bar(nw,w,0.1,'red');
title('Noisy Signal','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

// If object is present we receive the signal R(n) = x(n-D) + Noise
R=y+w;       // Original Signal+Noise
nr=nw;       // Index of received signal at RADAR

nr_fold=mtlb_fliplr(nr);
R_fold=mtlb_fliplr(R);
nmin=min(n)+min(nr_fold);		// Lowest index of y(n)
nmax=max(n)+max(nr_fold);		// Highest index of y(n)
n_received=nmin:nmax;
Received_Presence=conv(x,R_fold); // Convolution of Original signal and Received Signal in the Presence of Object (Equvalent to Correlation)//

scf();
subplot(2,1,1);
bar(n_received,Received_Presence,0.1,'red');
title('Correlation in the Presence of Object','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Correlation Value", "fontsize", 2, "color", "blue");

// If object is not present we receive the signal R(n) = Noise
R=w;                             // only Noise Signal
nr=nw;
nr_fold=mtlb_fliplr(nr);
R_fold=mtlb_fliplr(R);
nmin=min(n)+min(nr_fold);		// Lowest index of y(n)
nmax=max(n)+max(nr_fold);		// Highest index of y(n)
n_received=nmin:nmax;
Received_Absence=conv(x,R_fold); // Convolution of Original transmitted signal and Received Signal in the Absence of Object  (Equvalent to Correlation)//

subplot(2,1,2);
bar(n_received,Received_Absence,0.1,'Green');
title('Correlation in the Absence of Object','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Correlation Value", "fontsize", 2, "color", "blue");


// INPUT Parameters
//D=10;                       // Delay amount
//x=[0 1 2 3 2 1 0];          //Triangle pulse transmitted by radar
//n=[-3 -2 -1 0 1 2 3];       // Index of Triangular Pulse

// OUT PUT Parameter
//R=[0.2113249    0.7560439    0.0002211    0.3303271    0.6653811 0.6283918    0.8497452 ]
//Received_Presence=[0.    0.8497452    3.3278823    8.4714004    15.245755    20.763547 22.706621    19.050111    13.021551    6.1462834    2.1786936 0.2113249    0]
//Received_Absence=[0.    0.8497452    2.3278823    4.4714004    5.2457551    4.7635474 3.7066214    3.0501113    3.0215507    2.1462834    1.1786936 0.2113249    0]


